-- Dodge Timer Test Script by Chaplain Grimaldus --
local WriteInfoLogs = true -- Set to true to enable info logging

local Re = re
local Sdk = sdk
local Log = log

-- Log Functions
local function log_info(info_message)
  if WriteInfoLogs then
    Log.info("[Chaplain Grimaldus > Dodge Timer Test]: " .. info_message)
  end
end

local function log_error(error_message)
  Log.error("[Chaplain Grimaldus > Dodge Timer Test]: " .. error_message)
end

log_info("Loaded")

local currentScene = nil
local playerFound = false
local delayCounter = 0
local delayThreshold = 60 -- Number of frames to wait before retrying (adjust as needed)

-- Function to set the dodge timers to 0
local function set_dodge_timers(scene)
  if not scene then
    log_error("No valid scene found to set dodge timers")
    return
  end

  -- Get the player object
  local playerObject = scene:call("findGameObject(System.String)", "Pl_Frank")
  if playerObject then
    -- Get the PlayerCondition component
    local playerCondition = playerObject:call("getComponent(System.Type)",
      sdk.typeof("app.solid.survivor.player.PlayerCondition"))
    if playerCondition then
      -- Access the PlayerSetting -> TimerSetting structure
      local playerSetting = playerCondition:get_field("<PlayerSetting>k__BackingField")
      if playerSetting then
        local timerSetting = playerSetting:get_field("TimerSetting")
        if timerSetting then
          -- Set both DodgeTimer and UIDodgeTimer to 0
          timerSetting:set_field("DodgeTimer", 0)
          timerSetting:set_field("UIDodgeTimer", 0)
          log_info("DodgeTimer and UIDodgeTimer successfully set to 0")
        else
          log_error("TimerSetting not found on PlayerSetting")
        end
      else
        log_error("PlayerSetting field not found on PlayerCondition component")
      end
    else
      log_error("Component 'app.solid.survivor.player.PlayerCondition' not found on the player object")
    end
  else
    log_error("Player object 'Pl_Frank' not found in the scene")
  end
end

-- Scene updating logic with delay mechanism
Re.on_pre_application_entry("LockScene", function()
  local sceneManager = Sdk.get_native_singleton("via.SceneManager")
  if not sceneManager then
    log_info("SceneManager not found")
    return
  end

  -- Get the current scene
  local scene = Sdk.call_native_func(sceneManager, Sdk.find_type_definition("via.SceneManager"), "get_CurrentScene")
  if scene ~= currentScene then
    playerFound = false
    currentScene = scene
    delayCounter = 0 -- Reset the delay counter when the scene changes
    log_info("Scene has changed, resetting dodge timer test")
  end

  -- Keep checking for player in the scene with delay
  if scene and not playerFound and delayCounter >= delayThreshold then
    local player = scene:call("findGameObject(System.String)", "Pl_Frank")
    if player then
      playerFound = true
      log_info("Player found in scene")
      -- Once the player is found, set the dodge timers to 0
      set_dodge_timers(scene)
    else
      log_info("Player not yet found, retrying...")
    end
  end
end)

-- Frame update function to handle delay counter
Re.on_frame(function()
  if not playerFound then
    delayCounter = delayCounter + 1 -- Increment the counter each frame until the threshold is reached
  end
end)
